/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.api.VWXMLSchemaSubType;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.api.WSParamChoices;
import filenet.ws.api.WSParamGroup;
import filenet.ws.api.WSParamParent;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WSParam {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSParam";
    protected WSParamParent m_parent = null;
    protected String m_name = null;
    protected String m_namespace = null;
    protected String m_typeName = null;
    protected String m_typeNSPrefix = null;
    protected String m_partName = null;
    protected boolean m_bArrayElement = false;
    private static String m_arrayElementTagName = "Item";
    protected int m_type = -1;
    protected int m_subType = -1;
    protected String m_attribute = null;
    protected boolean m_bAttachmentRef = false;
    protected boolean m_bRPC = false;
    protected boolean m_bBaseType = false;
    protected static Hashtable s_types = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.18  $";
    }

    public abstract String toXML();

    public abstract String toXMLTemplate();

    protected abstract void addTemplateElement(Document var1, Element var2, int var3);

    protected abstract void populate(Node var1);

    protected abstract void reset();

    protected abstract void removeAll();

    protected abstract WSParam clone(WSParamParent var1);

    protected abstract Vector getFlatParamList();

    public WSParam() {
    }

    public void releaseReferences() {
        block2: {
            try {
                this.m_parent = null;
                this.m_name = null;
                this.m_namespace = null;
                this.m_typeName = null;
                this.m_typeNSPrefix = null;
                this.m_partName = null;
                this.m_attribute = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block2;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSParam(WSParamParent parent, String name, String namespace, String typeNSPrefix, String typeName) {
        this.m_parent = parent;
        this.m_name = name;
        this.m_namespace = namespace;
        this.m_typeNSPrefix = typeNSPrefix;
        if (typeName != null && typeName.compareTo("base64") == 0) {
            typeName = "base64Binary";
        }
        this.m_typeName = typeName;
        if (this.m_typeName == null) {
            this.m_typeName = new Object().getClass().getName();
        }
        if (this.m_typeName != null) {
            this.m_type = WSParam.getType(this.m_typeName);
            try {
                this.m_subType = VWXMLSchemaSubType.stringToType(this.m_typeName);
            }
            catch (Exception ex) {
                this.m_subType = -1;
            }
        }
    }

    protected static Node[] findNodes(NodeList list, String name) {
        if (list != null && name != null) {
            Node node = null;
            Vector<Node> v = new Vector<Node>();
            for (int i = 0; i < list.getLength(); ++i) {
                node = list.item(i);
                if (node == null || VWStringUtils.compare(name, node.getNodeName()) != 0) continue;
                v.add(node);
            }
            if (v != null && v.size() > 0) {
                Node[] nodes = new Node[v.size()];
                v.toArray(nodes);
                v.clear();
                return nodes;
            }
        }
        return null;
    }

    protected static Node[] getPartNodes(Document doc) {
        Node[] nodes = null;
        if (doc != null) {
            Element rootNode = doc.getDocumentElement();
            String s = rootNode.getAttribute("tempRoot");
            if (VWStringUtils.compare(s, "1") == 0) {
                NodeList nodeList = rootNode.getChildNodes();
                if (nodeList != null && nodeList.getLength() > 0) {
                    Node node = null;
                    Vector<Node> partNodes = new Vector<Node>();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = nodeList.item(i);
                        if (node == null || !(node instanceof Element)) continue;
                        partNodes.add(nodeList.item(i));
                    }
                    nodes = new Node[nodeList.getLength()];
                    if (partNodes.size() > 0) {
                        nodes = new Node[partNodes.size()];
                        partNodes.toArray(nodes);
                        partNodes.clear();
                    }
                }
            } else {
                nodes = new Node[]{rootNode};
            }
        }
        return nodes;
    }

    protected static int getType(String typeName) {
        if (typeName != null) {
            Object obj;
            if (typeName.endsWith("[]")) {
                typeName = typeName.substring(0, typeName.length() - 2);
            }
            if (s_types != null && (obj = s_types.get(typeName)) != null && obj instanceof Integer) {
                return (Integer)obj;
            }
        }
        return -1;
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public int getLevel() {
        if (this.m_parent != null) {
            int parentLevel = this.m_parent.getLevel();
            if (this.m_parent instanceof WSParamGroup || this.m_parent instanceof WSParamChoices) {
                return parentLevel;
            }
            return parentLevel + 1;
        }
        return 0;
    }

    public String getName() {
        int index;
        if (this.m_name != null && (index = this.m_name.lastIndexOf(">")) != -1) {
            this.m_name = this.m_name.substring(index + 1);
        }
        return this.m_name;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public WSParam getParent() {
        return this.m_parent;
    }

    public int getType() {
        return this.m_type;
    }

    public int getSubType() {
        return this.m_subType;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean isAttachmentReference() {
        return this.m_bAttachmentRef;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isArrayParent() {
        return false;
    }

    public boolean isChoice() {
        return false;
    }

    void setAttachmentRef(boolean bValue) {
        this.m_bAttachmentRef = bValue;
    }

    public boolean isArrayElement() {
        return this.m_bArrayElement;
    }

    public String getTagName() {
        if (this.isArrayElement() && this.isRPC()) {
            return m_arrayElementTagName;
        }
        return this.getName();
    }

    void setXmlString(boolean bValue) {
        if (bValue && this.m_type == 2) {
            this.m_type = 128;
        }
    }

    void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }

    public String toString() {
        String s = new String();
        s = s + "Name = " + this.getName() + "\n";
        s = s + "Type name = " + this.getTypeName() + "\n";
        s = s + "Namespace = " + this.getNamespace() + "\n";
        return s;
    }

    protected boolean isSameNamespace(String namespace) {
        return VWStringUtils.compare(this.m_namespace, namespace) == 0;
    }

    protected Element createElement(Document doc, int bindingStyle) {
        Element element = doc.createElement(this.getTagName());
        if (this.m_parent == null || !this.m_parent.isSameNamespace(this.m_namespace)) {
            element.setAttribute("xmlns", this.m_namespace);
        }
        return element;
    }

    protected Element createTemplateElement(Document doc, int bindingStyle) {
        String tagName = this.getTagName();
        if (tagName == null) {
            return null;
        }
        Element element = doc.createElement(tagName);
        if (this.m_parent == null || !this.m_parent.isSameNamespace(this.m_namespace)) {
            element.setAttribute("xmlns", this.m_namespace);
        }
        if (bindingStyle == 2) {
            if (this.m_typeNSPrefix != null) {
                element.setAttribute("xsi:type", this.m_typeNSPrefix + ":" + this.m_typeName);
            } else {
                element.setAttribute("xsi:type", this.m_typeName);
            }
        }
        return element;
    }

    protected void copyTo(WSParam to) {
        to.m_parent = this.m_parent;
        to.m_name = this.m_name;
        to.m_namespace = this.m_namespace;
        to.m_typeName = this.m_typeName;
        to.m_typeNSPrefix = this.m_typeNSPrefix;
        to.m_partName = this.m_partName;
        to.m_attribute = this.m_attribute;
        to.m_type = this.m_type;
        to.m_subType = this.m_subType;
        to.m_bAttachmentRef = this.m_bAttachmentRef;
        to.m_bRPC = this.m_bRPC;
        to.m_bBaseType = this.m_bBaseType;
        to.m_bArrayElement = this.m_bArrayElement;
    }

    protected String getTypeNamespacePrefix() {
        return this.m_typeNSPrefix;
    }

    String getPartName() {
        return this.m_partName;
    }

    void setPartName(String name) {
        this.m_partName = name;
    }

    void setRPC(boolean bRPC) {
        this.m_bRPC = bRPC;
    }

    boolean isRPC() {
        if (this.m_bRPC) {
            return this.m_bRPC;
        }
        if (this.m_parent != null) {
            return this.m_parent.isRPC();
        }
        return this.m_bRPC;
    }

    boolean isBaseType() {
        return this.m_bBaseType;
    }

    void setBaseType(boolean bBaseType) {
        this.m_bBaseType = bBaseType;
    }

    void setArrayElement(boolean bArrayElement) {
        this.m_bArrayElement = bArrayElement;
    }

    static {
        s_types = new Hashtable();
        s_types.put(new String("byte"), new Integer(1));
        s_types.put(new String("unsignedByte"), new Integer(1));
        s_types.put(new String("integer"), new Integer(1));
        s_types.put(new String("positiveInteger"), new Integer(1));
        s_types.put(new String("negativeInteger"), new Integer(1));
        s_types.put(new String("nonNegativeInteger"), new Integer(1));
        s_types.put(new String("nonPositiveInteger"), new Integer(1));
        s_types.put(new String("int"), new Integer(1));
        s_types.put(new String("unsignedInt"), new Integer(1));
        s_types.put(new String("long"), new Integer(1));
        s_types.put(new String("unsignedLong"), new Integer(1));
        s_types.put(new String("short"), new Integer(1));
        s_types.put(new String("unsignedShort "), new Integer(1));
        s_types.put(new String("duration "), new Integer(2));
        s_types.put(new String("gMonth "), new Integer(2));
        s_types.put(new String("gYear "), new Integer(2));
        s_types.put(new String("gYearMonth "), new Integer(2));
        s_types.put(new String("gDay "), new Integer(2));
        s_types.put(new String("gMonthDay"), new Integer(2));
        s_types.put(new String("string"), new Integer(2));
        s_types.put(new String("normalizedString"), new Integer(2));
        s_types.put(new String("token"), new Integer(2));
        s_types.put(new String("Name"), new Integer(2));
        s_types.put(new String("QName"), new Integer(2));
        s_types.put(new String("NCName"), new Integer(2));
        s_types.put(new String("anyURI"), new Integer(2));
        s_types.put(new String("language"), new Integer(2));
        s_types.put(new String("ID"), new Integer(2));
        s_types.put(new String("IDREF"), new Integer(2));
        s_types.put(new String("IDREFS"), new Integer(2));
        s_types.put(new String("ENTITY"), new Integer(2));
        s_types.put(new String("ENTITIES"), new Integer(2));
        s_types.put(new String("NOTATION"), new Integer(2));
        s_types.put(new String("NMTOKEN"), new Integer(2));
        s_types.put(new String("NMTOKENS"), new Integer(2));
        s_types.put(new String("boolean"), new Integer(4));
        s_types.put(new String("date"), new Integer(16));
        s_types.put(new String("time"), new Integer(16));
        s_types.put(new String("dateTime"), new Integer(16));
        s_types.put(new String("decimal"), new Integer(8));
        s_types.put(new String("float"), new Integer(8));
        s_types.put(new String("double"), new Integer(8));
        s_types.put(new String("base64Binary"), new Integer(32));
        s_types.put(new String("base64"), new Integer(32));
        s_types.put(new String("hexBinary"), new Integer(32));
    }
}

